h48966
s 00001/00001/00158
d D 1.2 04/07/08 10:08:40 abogaty 2 1
c 
e
s 00159/00000/00000
d D 1.1 04/07/08 10:08:04 abogaty 1 0
c date and time created 04/07/08 10:08:04 by abogaty
e
u
U
f e 0
t
T
I 1
#include "defs.h"
/* -------------------------------------------------------------------------------------------- */
#ifdef BUGGY_GETHOSTBYNAME
struct hostent *FIXED_gethostbyname(char *name){
	int i;
	struct stat st;
	int fds[128];

	struct hostent *hp;

	for(i=0; i < 128; i++){
		fds[i] = (fstat(i, &st) >= 0) ? 1 : 0;
	}
	hp = gethostbyname(name);
	/* Close extra file descriptors */
	for(i=0; i < 128; i++){
		if(fstat(i, &st) >= 0 && fds[i] == 0){
			fprintf(stderr, "gethostbyname: extra fd=%d closed\n", i);
			close(i);
		}
	}
	return hp;
}
#else
struct hostent *FIXED_gethostbyname(char *name){
	return gethostbyname(name);
}
#endif

/* -------------------------------------------------------------------------------------------- */
struct host_cache {
	char *hostname;
	int valid;
	struct hostent host;
	unsigned long count;

	struct host_cache *next;
} *hostList = NULL;

unsigned long hostname_requests = 0L;
unsigned long hostname_real_requests = 0L;

struct hostent *MY_gethostbyname(char *name){
	struct hostent *hp;
	struct host_cache *ptr;

	hostname_requests++;
	/* Look into the cache first */
	for(ptr=hostList; ptr; ptr=ptr->next){
		if(!strcmp(name, ptr->hostname)){
			ptr->count++;
			if(ptr->valid)
				return & ptr->host;
			else
				return NULL;
		}
	}

	/* Not found. Add new one */
	ptr = (struct host_cache *) calloc(1, sizeof(*ptr));
	ptr->hostname = strdup(name);
	ptr->count = 1;

	/* Insert into list */
	ptr->next = hostList;
	hostList = ptr;

	hostname_real_requests++;
	hp = FIXED_gethostbyname(name);

	if(hp == NULL){
		ptr->valid = 0;
		return NULL;
	}
	ptr->valid = 1;

	ptr->host = *hp;

	/* But now make a copy of address list */
	ptr->host.h_addr_list = copyAddresses(hp);

	return & ptr->host;
}
void printHostStats(FILE *fp){
	struct host_cache *ptr;
	struct sockaddr_in out;

	fprintf(fp, "\n\nNAME REQUESTS: %ld ISSUED TO DNS: %ld\n",
		hostname_requests, hostname_real_requests);

	for(ptr=hostList; ptr; ptr=ptr->next){

D 2
		fprintf(fp, "%08lx\t", ptr->count);
E 2
I 2
		fprintf(fp, "%08ld\t", ptr->count);
E 2
		if(ptr->valid == 0){
			fprintf(fp, "<INVALID>\t\t\t");
		} else {
			memset((char *) &out, 0, sizeof(out));
			memcpy((char *) &out.sin_addr, ptr->host.h_addr_list[0], ptr->host.h_length);
			fprintf(fp, "%-15s\t\t", inet_ntoa(out.sin_addr));
		}
		fprintf(fp, "%s\n", ptr->hostname);
	}
}
/* -------------------------------------------------------------------------------------------- */
char **copyAddresses(struct hostent *hp){
	int count, i;
	char **p;
	char **vectptr;

	count = lengthVector(hp->h_addr_list);
	vectptr = (char **) calloc(sizeof(char *), count + 1);

	for (p = hp->h_addr_list, i=0; *p != NULL; p++, i++){
		vectptr[i] = (char *) calloc(1, hp->h_length);
		(void) memcpy(vectptr[i], *p,  hp->h_length);
	}
	return vectptr;
}
struct in_addr *saveAddresses(struct hostent *hp){
	int count, i;
	char **p;
	struct in_addr *vectptr;

	count = lengthVector(hp->h_addr_list);
	vectptr = (struct in_addr *) calloc(sizeof(struct in_addr), count + 1);

	for (p = hp->h_addr_list, i=0; *p != NULL; p++, i++){
		(void) memcpy(&vectptr[i].s_addr, *p, sizeof(struct in_addr));
#ifdef DEBUG
		fprintf(fplog, "\tADDR: %s\n", inet_ntoa(vectptr[i]));
#endif
	}
	return vectptr;
}

void saveAddrList(URL *ptr, struct hostent *hp){
	if(ptr->address_list == NULL)
	   ptr->address_list = saveAddresses(hp);
}

Bool oneOfAddresses(char *hostname, struct in_addr *addresses){
	struct hostent *hp;
	struct in_addr hostaddr, *addrptr;
	char **p;

	if((hp = MY_gethostbyname(hostname)) == NULL)
		return FALSE;

	memcpy((char *) &hostaddr.s_addr, (hp->h_addr_list)[0], sizeof hostaddr.s_addr);

	for (p = (char **) addresses; *p != 0; p++){
		addrptr = (struct in_addr *) p;

		if(addrptr->s_addr == hostaddr.s_addr)
			return TRUE;

	}
	return FALSE;
}
E 1
