#ifdef DESCRIPTION

	Copyright Andrew Bogatyrew (C) 1996, 1997
	-----------------------------------------------------------------
	This program is a Freeware, provided the copyright above is kept.
	Author kindly asks the modifiers to inform him about the
	enhancements and bug fixes. Good luck!

	Under the terms of GNU Public License (GPL).
	-----------------------------------------------------------------
	Usage:

		webcp -KEYS http://hostname/pathname
		      -d        debug
		      -v        verbose
		      -r        recursive (follow links at the other hosts)
		      -pic      save ONLY *.gif *.jpg
		      -n        no retry (in the case of a failure)
		      -k        save the HTTP error reports (in *.ERR files)
		      -ill      accept     http:/dir/file as local URLs
				(note: NOT http://host/dir/file)

		      -a        append mode: do not try to get a URL if the
				corresponding file already exists in the SPOOLDIR
				and has non-zero size.
				(intended to get more files but not all again)

		      -sr       ignore /index.html
		      -sp       ignore HREF="../"
		      +sc       DO NOT ignore /cgi-bin/...
		      -sup      ignore parents.

				If the document is
					/a/b/c/                 /a/b/c/d.html
				then ignore
					/a/b/                   /a/b/
					/a/                     /a/
					/                       /
							   but
								/a/b/c/  are allowed.
								/a/b/x...

		      -h        HREF="..." only; exclude images

		      -skip /.../dir/
		      -skip /.../doc.html
				do not even try to get URLs under this directory
				or ignore the document mentioned.
				There may be a lot of such keys:
					-skip /images/ -skip /people/ -skip /cgi-bin/

		      -skipthis /.../dir/
				Skip JUST this dir, but allow files under.

		      -nohref /.../dir/
		      -nohref /.../doc.html
				get the URL itself, but do not follow HREF="..."
				in it.

				Attention!!!
				NOT   -skip http://host/dirs/dir/
				BUT   -skip            /dirs/dir/

		      -under
				get ONLY files that are placed under the
				directory stated as the argument:

				webcp -under http://host/dir1/.../dirN/

				(do not loose the ending "/" !!!)

				gets all /dir1/.../dirN/*
				gets all /dir1/.../dirN/*/*
				gets all /dir1/.../dirN/*/*/*
					......
				and ignores everythings other.

			-file file
				loads URLs list to visit from file

			-port <port>    Use instead of 80.

			-proxy <proxyhostname> <proxyport>

	The resulting files will be found in
		$HOME/WWWcache/hostname/...
	The log files are in
		$HOME/WWWcache/Logs/...

	-logdir directory
		changes $HOME/WWWcache to <directory>

	Typicall call is:

		webcp -d -sr -sp -sup -skip /people/   http://hostname/somedir

#endif

#include "defs.h"
#include <stdarg.h>
#include <signal.h>
#include <errno.h>
#include <time.h>

List     workList;  /* zero filled */
u_short  HTTPPORT;
u_short  basePort               = 0;
u_short  proxy_port		= 0;
char    *HOME;
int      recflag                = 0;
int      debugflag              = 0;
int      keepflag               = 0;
int      retryflag              = 1;
int      picsonlyflag           = 0;
int      appendflag             = 0;
int      weak_appendflag        = 0;
int      reget_appendflag       = 0;
int      skiprootdir            = 0;
int      skipparentdir          = 0;
int      skipparents            = 0;
int      skipcgiflag            = 1;
int      proxyflag		= 0;
int      underflag              = 0;
char    *underdir               = NULL;
int      nowarnflag             = 1;
int	 anysizeflag		= 0;
int	 anysizeflag_save	= 0;
int      redirsaveflag          = 1;
int      ill_urls_flag          = 0;
int      verbose                = 0;
int      keepalive              = 1;
int      hostflag               = 1;
int      xxdecodflag            = 0;
int      xxencodflag            = 1;
int      reassignportsflag      = 1;
int	 slashflag	        = 1;
int	 noreport		= 0;
FILE    *fplog, *fpreport;
char    *mylogdir               = NULL;
int      error_counter          = 0;
char    *loadfile               = NULL;
char    *authstring             = "";
int      nullflag               = FALSE;
char    *proxy_host		= NULL;
int	 maxhops		= 0;
int	 nobreak_amp		= 1;
int	 nobreak_spaces		= 0;	/* admit href="xxx xxx xxx" with spaces (0 by default) */
int	 break_on_spaces	= 1;
int	 stripOnSemicolon	= 0;
int	 trimURLspaces		= 0;
int	 use_gzip		= FALSE;
int	 relaxtime		= 0;
int	 text_as_HTML		= FALSE;
int	 headOnly		= FALSE;
int	 cutRedirs		= FALSE;
int	 nohup_flag		= TRUE;
int	 humanlike		= 0;
int	 redimages		= FALSE;
int	 limit404 = 0, count404 = 0;
int	 restart_intr		= 0;
int	 substitute_amp		= TRUE;	/* &amp; in URL names ==> &  */
int	 parse_arrays		= FALSE;
int	 power_tab_archive	= 0;
int	 drop_quot		= 0;
int	 skip_this		= 0;

int MAXTRYS                     = 25;
int RETRY_IMMEDIATELY           =  6;

unsigned long urlcounter        = 0;

char *activelog, *activelst, *activeticket;
char idname[64];
char logname[MAXPATHLEN];
char tmpname[128];
int pid;
static char *prog;
char hostname[256];
int  signalled = 0;

int    AC;	/* argc */
char **AV;	/* argv */

void talk_to_user(){
	char buf[256];
	int len;

again:
	fprintf(stderr, "CMD [help for help]> "); fflush(stderr);
	fgets(buf, sizeof(buf)-1, stdin);
	len = strlen(buf);
	if(len && buf[len-1]=='\n')
		buf[len-1]='\0';

	if(!*buf){
		return;
	}
	if(!strcmp(buf, "quit") || !strcmp(buf, "q")){
		die(-SIGINT);
	}
	if(!strcmp(buf, "skip")){
		skip_this = 1;
		return;
	}
	if(!strcmp(buf, "retry")){
		skip_this = 2;
		return;
	}
	if(!strcmp(buf, "human")){
		humanlike++;
		return;
	}
	if(!strcmp(buf, "robot")){
		humanlike=0;
		return;
	}
	if(!strncmp(buf, "black ", 6)){
		addNMatchPattern(buf+6, 0);        /* black list */
		return;
	}
	if(!strcmp(buf, "help")){
		fprintf(stderr, "quit - to quit\n");
		fprintf(stderr, "skip - to skip current file\n");
		fprintf(stderr, "retry - to retry current file\n");
		fprintf(stderr, "black <pattern> - to add pattern to blacklist\n");
		fprintf(stderr, "<ENTER> - just continue\n");
		goto again;
	}
}

void die(int nsig){
	int interactive = 1;

	if(nsig < 0){
		nsig = -nsig;
		interactive = 0;
		
	}
	if(nsig) fprintf(stderr, "\n### INTERRUPTED (%d) ***\n\n", nsig);
	if(nsig) fprintf(fplog,  "\n### INTERRUPTED (%d) ***\n\n", nsig);
	signalled = nsig;

	if(interactive && nsig == SIGINT){
		talk_to_user();
		signalled = 0;
		return;
	}

	reportList(&workList);
	printHostStats(fplog);
	fflush (fplog);
	fflush (fpreport);
	unlink (tmpname);

	fprintf(stderr, "\nBye, %s (pid=%08d) is completed %s on %s\n", prog, pid, currentDate(), hostname);
	fprintf(fplog,  "\nBye, %s (pid=%08d) is completed %s on %s\n", prog, pid, currentDate(), hostname);

	logItFinish(AV);
	unlink(activeticket);

	exit(nsig);
}
void dieabort(int nsig){
	if(nsig) fprintf(stderr, "\n### INTERRUPTED (%d) ***\n\n", nsig);
	if(nsig) fprintf(fplog,  "\n### INTERRUPTED (%d) ***\n\n", nsig);
	signalled = nsig;

	reportList(&workList);
	printHostStats(fplog);
	fflush (fplog);
	fflush (fpreport);
	unlink (tmpname);

	fprintf(stderr, "\nBye, %s (pid=%08d) is completed %s on %s\n", prog, pid, currentDate(), hostname);
	fprintf(fplog,  "\nBye, %s (pid=%08d) is completed %s on %s\n", prog, pid, currentDate(), hostname);

	logItFinish(AV);
	unlink(activeticket);

	abort();
}
int hangup_happened = 0;
void onhup(int nsig){
	sigset(SIGHUP, SIG_IGN);
	setsid();
	fprintf(fplog,  "\n\n\n### HANGUP - SIGHUP, %s (pid=%08d) %s on %s\n\n\n", prog, pid, currentDate(), hostname);
	hangup_happened++;
}

void logItStart(char **avorig){
	FILE *fp;

	pid = getpid();
	if((HOME = getenv("HOME")) == NULL)
		HOME = "/var/tmp";

	sprintf(tmpname, "%s/.webcplog", HOME);
	if((fp = fopen(tmpname, "a")) != NULL){
		fprintf(fp, "%08d %s: ", pid, currentDate());
		while(avorig[0]){
			fprintf(fp, "%s%s", avorig[0], avorig[1] ? " " : "\n");
			avorig++;
		}
		fclose(fp);
	}
}
void logItFinish(char **avorig){
	FILE *fp;

	pid = getpid();
	if((HOME = getenv("HOME")) == NULL)
		HOME = "/var/tmp";

	sprintf(tmpname, "%s/.webcplog.done", HOME);
	if((fp = fopen(tmpname, "a")) != NULL){
		fprintf(fp, "%-12s %08d %s [%d]: ", hostname, pid, currentDate(), signalled);
		while(avorig[0]){
			fprintf(fp, "'%s'%s", avorig[0], avorig[1] ? " " : "\n");
			avorig++;
		}
		fclose(fp);
	}
}

void byebye(void){}

void init(char *prog, char *logdir, int AC, char **AV){
	int n;

	pid = getpid();
	gethostname(hostname, sizeof(hostname)-2);
	fprintf(stderr, "Hello, %s (pid=%08d) is here on %s\n\n", prog, pid, hostname);

	if((HOME = getenv("HOME")) == NULL)
		HOME = "/var/tmp";

	/* sprintf(tmpname, "/tmp/%s-%08d.temp", prog, pid); */
	sprintf(tmpname, "./%s-%08d.temp", prog, pid);

	sprintf(idname, "%s.%08d", prog, pid);
	if(logdir != NULL){
		mkdir(logdir, 0777);

		sprintf(logname, "%s/Logs",        logdir);
		mkdir  (logname, 0777);

		sprintf(logname, "%s/Logs/%s.log", logdir, idname);

	} else {
		sprintf(logname, "%s/%s",             HOME, SPOOLDIR);
		mkdir  (logname, 0777);

		sprintf(logname, "%s/%s/Logs",        HOME, SPOOLDIR);
		mkdir  (logname, 0777);

		sprintf(logname, "%s/%s/Logs/%s.log", HOME, SPOOLDIR, idname);
	}
	fplog = fopen(logname, "w");
	if(fplog == NULL){
		fprintf(stderr, "Cannot create log file %s\n", logname);
		fplog = stderr;
	} else
		activelog = strspl(idname, ".log", NULL);
	setvbuf(fplog, NULL, _IOLBF, BUFSIZ);

	if(logdir != NULL){
		sprintf(logname, "%s/Logs/%s.lst",    logdir,         idname);
	} else {
		sprintf(logname, "%s/%s/Logs/%s.lst", HOME, SPOOLDIR, idname);
	}
	fpreport = fopen(logname, "w");
	if(fpreport == NULL)
		fpreport = stderr;
	else
		activelst = strspl(idname, ".lst", NULL);

	fprintf(fplog, "Hello, %s (pid=%08d) is starting %s on %s\n", prog, pid, currentDate(), hostname);
	fprintf(fplog, "CWD: %s\n", getcwd(NULL, MAXPATHLEN+1));
	while(AV[0]){
		fprintf(fplog, "'%s'%s", AV[0], AV[1] ? " " : "\n\n");
		AV++;
	}

	if(logdir != NULL){
		sprintf(logname, "%s/Logs/ACTIVE.%s",    logdir,         idname);
	} else {
		sprintf(logname, "%s/%s/Logs/ACTIVE.%s", HOME, SPOOLDIR, idname);
	}
	activeticket = strdup(logname);
	if(symlink(activelog, activeticket) < 0)
		perror("symlink");
}

static void report(int nsig){
	FILE *fp;

	if((fp = fopen("webcp.report", "w")) == NULL)
		return;
	fprintf(stderr, "\n\n*** REPORTING THE CURRENT STATE ***\n");
	reportShortList(&workList, fp);
	fclose(fp);
	fprintf(stderr, "*** DONE ***\n\n");
}

int main(int ac, char *av[]){
	struct sigaction act;

	AC = ac;
	AV = av;
	prog = basename(strdup(av[0]));
	logItStart(av);
	atexit(byebye);

	while(av[1] && (*av[1] == '-' || *av[1] == '+')){
		if(strcmp(av[1],      "-recurse")    ==0   || strcmp(av[1], "-r")   == 0)
			recflag++;
		else if(strcmp(av[1], "-maxhops")     ==0   || strcmp(av[1], "-hops")   == 0){
			maxhops = atoi(av[2]);
			recflag++;
			av++;
			ac--;
		}
		else if(strcmp(av[1], "-debug")      ==0   || strcmp(av[1], "-d")   == 0)
			debugflag++;
		else if(strcmp(av[1], "-verbose")    ==0   || strcmp(av[1], "-v")   == 0)
			verbose++;
		else if(strcmp(av[1], "-noretry")    ==0   || strcmp(av[1], "-n")   == 0)
			retryflag = 0;
		else if(strcmp(av[1], "-keep")       ==0   || strcmp(av[1], "-k")   == 0)
			keepflag++;
		else if(strcmp(av[1], "-append")     ==0   || strcmp(av[1], "-a")   == 0)
			appendflag++;
		else if(strcmp(av[1], "-Append")     ==0   || strcmp(av[1], "-A")   == 0){
			weak_appendflag++;
			appendflag++;
		}
		else if(strcmp(av[1], "-RegetIndx") ==0   || strcmp(av[1], "-RI")   == 0){
			reget_appendflag++;
			appendflag++;
		}
		else if(strcmp(av[1], "-pictures")   ==0   || strcmp(av[1], "-pic") == 0)
			picsonlyflag++;
		else if(strcmp(av[1], "-skiproot")   ==0   || strcmp(av[1], "-sr")  == 0)
			skiprootdir++;
		else if(strcmp(av[1], "-skipparent") ==0   || strcmp(av[1], "-sp")  == 0)
			skipparentdir++;
		else if(strcmp(av[1], "-skipparents")==0   || strcmp(av[1], "-sup") == 0)
			skipparents++;
		else if(strcmp(av[1], "-onlyhrefs")  ==0   || strcmp(av[1], "-h")   == 0)
			onlyHref();
		else if(strcmp(av[1], "+skipcgi")    ==0   || strcmp(av[1], "+sc")  == 0 || strcmp(av[1], "+cgi")==0)
			skipcgiflag = 0;
		else if(strcmp(av[1], "-under")      ==0   || strcmp(av[1], "-u")   == 0)
			underflag++;
		else if(strcmp(av[1], "-ill")        ==0   || strcmp(av[1], "-ill") == 0)
			ill_urls_flag++;
		else if(strcmp(av[1], "-translhex")  ==0   || strcmp(av[1], "-thex")  == 0)
			xxdecodflag++;
		else if(strcmp(av[1], "-noslash_after_question")  ==0   || strcmp(av[1], "-no/q")  == 0)
			xxencodflag = 0;
		else if(strcmp(av[1], "-nokeepalive")==0   || strcmp(av[1], "-nokal") == 0)
			keepalive = 0;
		else if(strcmp(av[1], "-nowarnings") ==0   || strcmp(av[1], "-nw")  == 0)
			nowarnflag++;
		else if(strcmp(av[1], "+nowarnings") ==0   || strcmp(av[1], "+nw")  == 0)
			nowarnflag = 0;
		else if(strcmp(av[1], "-anysize")    ==0   || strcmp(av[1], "-as")  == 0)
			anysizeflag++;
		else if(strcmp(av[1], "-anysize-save")==0  || strcmp(av[1], "-ass")  == 0)
			anysizeflag_save++;
		else if(strcmp(av[1], "-redirsave")  ==0   || strcmp(av[1], "-rs")  == 0)
			redirsaveflag++;
		else if(strcmp(av[1], "+redirsave")  ==0   || strcmp(av[1], "+rs")  == 0)
			redirsaveflag = 0;
		else if(strcmp(av[1], "+hostflag")   ==0   || strcmp(av[1], "+hf")  == 0)
			hostflag = 0;
		else if(strcmp(av[1], "-null")       ==0)
			nullflag = TRUE;
		else if(strcmp(av[1], "-slash")      ==0)
			slashflag++;
		else if(strcmp(av[1], "-restart_hup")==0)
			restart_intr++;
		else if(strcmp(av[1], "-404")      ==0)
			limit404++;			/* exit on the first (n-th) code 404 */
							/* use in scripts to get pages 1, 2, 3... N, code404 -> stop */
		else if(strcmp(av[1], "-gzip")       ==0)
			use_gzip = TRUE;
		else if(strcmp(av[1], "-texttoo")    ==0)
			text_as_HTML = TRUE;
		else if(strcmp(av[1], "-noreport")   ==0)
			noreport++;
		else if(strcmp(av[1], "+portflag")   ==0   || strcmp(av[1], "+pf")  == 0)
			reassignportsflag = 0;
		else if(strcmp(av[1], "-amp")   ==0)
			nobreak_amp++;
		else if(strcmp(av[1], "+amp")   ==0)
			nobreak_amp = 0;
		else if(strcmp(av[1], "-subst_amp")   ==0)
			substitute_amp++;
		else if(strcmp(av[1], "-stripSemicolon")   ==0){
			stripOnSemicolon++;
			nowarnflag = 0;
		}
		else if(strcmp(av[1], "-arrays")   ==0)
			parse_arrays++;
		else if(strcmp(av[1], "-spc")   ==0)	/* Admit spaces in href="... ..." */
			nobreak_spaces++;
		else if(strcmp(av[1], "+spc")   ==0)	/* Deny  spaces in href="... ..." */
			nobreak_spaces = 0;
		else if(strcmp(av[1], "-trim")   ==0)
			trimURLspaces++;
		else if(strcmp(av[1], "-cut_redirs")   ==0)
			cutRedirs = TRUE;
		else if(strcmp(av[1], "-verifysize") ==0)
			headOnly++;
		else if(strcmp(av[1], "-nohup") ==0)
			nohup_flag++;
		else if(strcmp(av[1], "-hup") ==0)
			nohup_flag = 0;
		else if(strcmp(av[1], "-human") ==0)
			humanlike++;
		else if(strcmp(av[1], "-PTA") == 0){
			nobreak_spaces++;
			power_tab_archive++;
		}
		else if(strcmp(av[1], "-drop_quot")   ==0)
			drop_quot = 1;
		else if(strcmp(av[1], "-skip")       ==0   && av[2] != NULL){
			addSkipItem(av[2], IGNORED);
			av++;
			ac--;
		} else if(strcmp(av[1], "-skipthis") ==0   && av[2] != NULL){
			addSkipItem(av[2], IGNORED|THISONLY);
			av++;
			ac--;
		} else if(strcmp(av[1], "-nohrefthis") ==0   && av[2] != NULL){
			addSkipItem(av[2], DONTPARSE|THISONLY);
			av++;
			ac--;
		} else if(strcmp(av[1], "-nohref")   ==0   && av[2] != NULL){
			addSkipItem(av[2], DONTPARSE);
			av++;
			ac--;
		} else if(strcmp(av[1], "-proxy")    ==0   && av[2] != NULL && av[3] != NULL){
			proxyflag++;
			proxy_host = av[2];
			proxy_port = htons(atoi(av[3]));
			av += 2;
			ac -= 2;
		} else if(strcmp(av[1], "-logdir")   ==0   && av[2] != NULL){
			mylogdir = av[2];
			av++;
			ac--;
		} else if(strcmp(av[1], "-file")     ==0   && av[2] != NULL){
			loadfile = av[2];
			av++;
			ac--;
		} else if(strcmp(av[1], "-auth")     ==0   && av[2] != NULL){
			authstring = av[2];
			av++;
			ac--;
		} else if(strcmp(av[1], "-redimages") ==0) {
			redimages++;
		} else if((strcmp(av[1], "-pattern")  ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-redlist")  ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-red")      ==0   && av[2] != NULL)){
			addMatchPattern(av[2], 0);         /* red list */
			av++;
			ac--;
		} else if((strcmp(av[1], "-pattern1") ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-redlist1") ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-red1")     ==0   && av[2] != NULL)){
			addMatchPattern(av[2], 1);         /* red list */
			av++;
			ac--;
		} else if((strcmp(av[1], "-npattern")  ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-blacklist") ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-black")     ==0   && av[2] != NULL)){
			addNMatchPattern(av[2], 0);        /* black list */
			av++;
			ac--;
		} else if((strcmp(av[1], "-npattern1") ==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-blacklist1")==0   && av[2] != NULL) ||
			  (strcmp(av[1], "-black1")    ==0   && av[2] != NULL)){
			addNMatchPattern(av[2], 1);        /* black list */
			av++;
			ac--;
		} else if(strcmp(av[1], "+host")     ==0   && av[2] != NULL){
			addAllowedHost(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-host")     ==0   && av[2] != NULL){
			addDeniedHost(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-port")     ==0   && av[2] != NULL){
			basePort = atoi(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-count")     ==0   && av[2] != NULL){
			urlcounter = atol(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-timeout")  ==0   && av[2] != NULL){
			TIMEOUT = atoi(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-relaxtime") ==0   && av[2] != NULL){
			relaxtime = atoi(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-maxtrys")  ==0   && av[2] != NULL){
			MAXTRYS = atoi(av[2]);
			av++;
			ac--;
		} else if(strcmp(av[1], "-immtrys")  ==0   && av[2] != NULL){
			RETRY_IMMEDIATELY = atoi(av[2]);
			av++;
			ac--;
		} else {
			fprintf(stderr, "%s: Unknown key %s\n", prog, av[1]);
			return 2;
		}
		av++;
		ac--;
	}

	if(ac != 2){
		int i;

		fprintf(stderr, "Usage: %s URLname\n", prog);
		fprintf(stderr, "Your arguments:\n");
		for(i=0; i < ac; i++)
			fprintf(stderr, "#%02d\t\"%s\"\n", i, av[i]);
		return 1;
	}

	init(prog, mylogdir, AC, AV);
	initWORDs();

	setlocale(LC_ALL, "");
	sigset(SIGINT,  die);
	sigset(SIGHUP,  die);
	sigset(SIGTERM, die);
	sigset(SIGSEGV, dieabort);

#ifndef SA_RESTART
# define SA_RESTART SA_NOABORT
#endif
	act.sa_handler   = (void (*)()) report;
	act.sa_flags     = SA_RESTART;  /* restart interrupted syscalls */
	sigemptyset(&act.sa_mask);
	sigaddset  (&act.sa_mask, SIGQUIT);
	if(sigaction  (SIGQUIT, &act, NULL) < 0)
		perror("sigaction");

	if(nohup_flag) {
		fprintf(stderr, "*** NOHUP PROTECTION IS ON ***\n");

		if(restart_intr > 1){
			act.sa_handler   = (void (*)()) onhup;
			act.sa_flags     = SA_RESTART;  /* restart interrupted syscalls */
			sigemptyset(&act.sa_mask);
			sigaddset  (&act.sa_mask, SIGHUP);
			if(sigaction  (SIGHUP, &act, NULL) < 0)
				perror("sigaction");
		} else
			sigset(SIGHUP, onhup);
	}

	initNet();

	addFirst(&workList, av[1]);
	if(loadfile)
		loadURLFile(&workList, loadfile);

	while(countRemaining(&workList, NULL) != 0){
		mainLoop(&workList);

		if(retryflag)
			retryNotReceived(&workList);

		sync();
	}
	die(0);
	return 0;
}

char *basename(char *s){
	char *ptr;

	if((ptr = strrchr(s, '/')) != NULL && ptr[1] != '\0'){
		*ptr = '\0';
		return ptr + 1;
	}
	return s;
}

void lowercase(unsigned char *s){
	while(*s){
		if(isupper(*s))
			*s = tolower(*s);
		s++;
	}
}
void lowercaseHostName(unsigned char *s){
	while(*s && *s != '/' && *s != '@' && *s != ':'){
		if(isupper(*s))
			*s = tolower(*s);
		s++;
	}
}
char *strend(char *s){
	while(*s) s++;
	return s;
}
/* ptr to the last but \0 character of the word */
char *strlast(char *s){
	char *p = s;

	while(*p) p++;
	return (p == s || p == s+1) ? s : (p-1);
}

char *strspl(char *s1, ...){
	va_list args;
	char *snew, *next;
	int   argcount = 0, length, i;
	char *argvector[128];

	length = strlen(s1) + 1;

	va_start(args, s1);
	for(;;){
		next = argvector[argcount] = va_arg(args, char *);

		if(next == NULL)
			break;

		length += strlen(next);
		argcount++;
	}
	va_end(args);

	snew = (char *) malloc(length);;
	strcpy(snew, s1);
	for(i=0; i < argcount; i++)
		strcat(snew, argvector[i]);

	return snew;

}

int lengthVector(char **vect){
	int len;

	for(len=0; *vect; vect++)
		len++;
	return len;
}
char **saveVector(char **vect){
	int len = lengthVector(vect), i;
	char **vectptr;

	vectptr = (char **) calloc(sizeof(char *), len+1);
	for(i=0; i < len; i++)
		vectptr[i] = strdup(vect[i]);
	return vectptr;
}

Bool makepath(
	char *path,     /* IN */
	Bool  redirected,
	char *newname   /* OUT buffer */
){
	struct stat st;
	char *last   = strrchr(path, '/');
	char *prefix = strchr (path, '/');       /* root directory */
	char savechar;
	Bool testEquality = FALSE;

#ifdef DEBUG
	fprintf(fplog, "\tmakepath %s\n", path);
#endif
	for(;;){
		prefix = strchr(prefix+1, '/');
		if(prefix == NULL)      /* 'twas the last component */
			break;

		savechar = *prefix;
		*prefix = '\0';

		if(stat(path, &st) < 0){
	makedir:
			if(mkdir(path, 0777) < 0){
				fprintf(fplog, "\tmkdir %s ", path);
				myperror("mkdir");
			}

		} else if( !isdir(st)){
			/*
				/......./aaa/...../bbb
					 aaa is NOT a dir !!!

			 1)     rename
				/......./aaa to
				/......./aaa.OLD

			 2)     IF there is /......./aaa.DIR
				THEN        rename it to
					    /......./aaa
				ELSE  mkdir /......./aaa
			*/

			fprintf(fplog, "\n\t@@@ Not a directory: %s\n", path);
			if(strlen(path) > (mylogdir ? 0 : strlen(HOME)) ){

				/* Step 1 */
				sprintf(newname, "%s%s", path, NAME_OLD);

				fprintf(fplog, "\t\t*** RENAMING %s -> %s\n\n", path, newname);
				if(rename(path, newname) < 0)
					myperror(newname);

				/* Step 2 */
				sprintf(newname, "%s%s", path, NAME_DIR);
				if(stat(newname, &st) >= 0 && isdir(st)){

					fprintf(fplog, "\t\t*** RENAMING %s -> %s\n\n", newname, path);
					if(rename(newname, path) < 0){
						myperror(newname);
						goto makedir;
					}
				} else
					goto makedir;
			}
		}
		*prefix = savechar;

		if(prefix == last) break;

	} /* endfor */

check_if_exists:
	/* test if the target file already exists */
	if(stat(path, &st) >= 0){
		/* YES, it exists. */

		/* If there is a directory /xxx/yyy/*
		   and suddenly there happens a redirection for /xxx/yyy
		   then it wants to save redirection info into /xxx/yyy
		   It causes renaming of the directory /xxx/yyy/ to /xxx/yyy.DIR
		   and making a dumb file /xxx/yyy containing trhe phrase "redirected".
		   So it is better to NOT save the redirection info if there is
		   a directory already.
		   Here we propose the other solution - giving the other filename.
		 */
		if(redirected == TRUE /* && isdir(st) */ ){
			strcat(path, NAME_REDIR);
			redirected = FALSE;
			goto check_if_exists;
		}

		/*

			/..../existing  -> /..../existing.DIR   (if it is a dir)
			/..../existing  -> /..../existing.OLD   (if it is a data)

		*/

		sprintf(newname, "%s%s", path, isdir(st) ? NAME_DIR : NAME_OLD);

		/* If "*.OLD" is a plain file do this */
		if(!isdir(st)){
			struct stat stold;

			if(stat(newname, &stold) >= 0){

			/* There already is *.OLD    */
			/* move *.OLD --> *.OLD.9999 */

				char number[32];
				char *newoldname;
				int n = 1;
				struct stat stnew;
				/* we have to move .OLD -> .OLD.9999 */

				if(stold.st_size == 0){
					(void) unlink(newname);

				} else {

					for(;;){
						sprintf(number, "%04d", n);
						newoldname = strspl(newname, ".", number, NULL);

						if(stat(newoldname, &stnew) < 0){
							/* There is NO file with a such name */
							break; /* for */
						}
						free(newoldname);
						n++;
					}
					fprintf(fplog,  "\t@@@ File already exists, RENAMING %s -> %s\n", newname, newoldname);
					fprintf(stderr, "\t@@@ File already exists, RENAMING %s -> %s\n", newname, newoldname);

					(void) rename(newname, newoldname);
					free(newoldname);
				}
			}
		}

		fprintf(fplog,  "\t@@@ File already exists, RENAMING %s -> %s\n", path, newname);
		fprintf(stderr, "\t@@@ File already exists, RENAMING %s -> %s\n", path, newname);

			/* ------>  */
		if(rename(path, newname) < 0)
			myperror(newname);
		else if(!isdir(st))
			testEquality = TRUE;    /* renamed && is a plain file  */
						/* newname[] contains the name */
	}
	return testEquality;
}

void myperror(char *msg){
	fprintf(fplog,  "@ERROR %s: %s\n", msg, strerror(errno));
	fprintf(stderr, "@ERROR %s: %s\n", msg, strerror(errno));      /* copy to the screen */

	fflush(fplog);
}

/* returns TRUE if files are the same in contents and length */
Bool compareFiles(char *n1, char *n2){
	FILE *f1, *f2;
	int c1, c2;
	Bool answer;

	if((f1 = fopen(n1, "r")) == NULL)
		return FALSE;

	if((f2 = fopen(n2, "r")) == NULL){
		fclose(f1);
		return FALSE;
	}

	for(;;){
		c1 = getc(f1);
		c2 = getc(f2);

		if(c1 == EOF && c2 == EOF){
			answer = TRUE;          /* equal files */
			break;
		}
		if(c1 != c2){                   /* One of them can be EOF */
			answer = FALSE;         /* different */
			break;
		}
	}
	fclose(f1);
	fclose(f2);

	return answer;
}

char *currentDate(){
	time_t tim;
	char *s, *cut;

	time(&tim);
	s = ctime(&tim);
	if((cut = strrchr(s, '\n')) != NULL) *cut = '\0';
	return s;
}

/* Does str have a suffix suff ? */
Bool strsuffix(char *str, char *suff){
	int len_str = strlen(str);
	int len_suf = strlen(suff);

	if(len_str < len_suf)
		return FALSE;

	return strcasecmp(str + len_str - len_suf, suff) == 0 ? TRUE : FALSE;
}
Bool isimage(URL *ptr){
	char *name = ptr->urlName;
	char *type = ptr->ctype;

	if(strsuffix(name, ".css"))  return TRUE;	/* Style Sheet -- always save */
	if(strsuffix(name, ".js"))   return TRUE;	/* Java Script -- always save */

	if(strsuffix(name, ".gif"))  return TRUE;
	if(strsuffix(name, ".jpg"))  return TRUE;
	if(strsuffix(name, ".jpeg")) return TRUE;
	if(strsuffix(name, ".tif"))  return TRUE;
	if(strsuffix(name, ".png"))  return TRUE;
	if(strsuffix(name, ".pdf"))  return TRUE;
	if(strsuffix(name, ".djv"))  return TRUE;
	if(strsuffix(name, ".djvu")) return TRUE;
	if(strsuffix(name, ".doc"))  return TRUE;	/* MS Word */
/*	if(strsuffix(name, ".txt"))  return TRUE;	/* Plain text */
	if(strsuffix(name, ".mp3"))  return TRUE;	/* sound   */
	if(strsuffix(name, ".mid"))  return TRUE;	/* sound  MIDI */
	if(strsuffix(name, ".swf"))  return TRUE;	/* Video   */
	if(strsuffix(name, ".zip"))  return TRUE;	/* Archive */
	if(strsuffix(name, ".tgz"))  return TRUE;	/* Archive */
	if(strsuffix(name, ".rar"))  return TRUE;	/* Archive */
	/* if(strsuffix(name, ".ps"))   return TRUE; */

	if(type != NULL){
		if(!strcasecmp(type, "image/gif"))  return TRUE;
		if(!strcasecmp(type, "image/jpeg")) return TRUE;
		if(!strcasecmp(type, "image/tiff")) return TRUE;
	}
	return FALSE;
}

#ifdef USE_EMUSIG
void (*sigset(int signo, void (*f)()))(){
	struct sigaction sa_new, sa_old;

	sigemptyset(&sa_new.sa_mask);
	sigaddset  (&sa_new.sa_mask, signo);
	sa_new.sa_handler = f;
	sa_new.sa_flags   = 0;

	sigaction(signo, &sa_new, &sa_old);

	return sa_old.sa_handler;
}
#endif /*USE_EMUSIG*/
